# -*- coding: utf-8 -*-
#__author__ = 'Arvin'
from django.core.management.base import BaseCommand
from ooredis import *
import uuid
import time
import os
import json
import base64


def save_file(r_objs):
    val = r_objs.random()
    if val and val != 'wait':
        file_info = json.loads(val)
        file_name = file_info['file_name']
        path = file_info['path']
        file_data = base64.b64decode(file_info['file_data'])
        file_path = os.path.join(os.getcwdu(), '%s/%s' % (path, file_name))
        fn = os.path.split(file_path)
        try:
            if not os.path.exists(fn[0]):
                os.makedirs(fn[0])
        except Exception, e:
            print e
        f = file(file_path, "w+b")
        f.write(file_data)
        f.close()
        r_objs.remove(val)
    r_objs.expire(60)


class Command(BaseCommand):
    """
    异步保存静态文件
    在多服务器情况下, 保持各个务器上的静态文件一致
    """
    option_list = BaseCommand.option_list + ()
    help = "Start save local process."
    args = ''

    def handle(self, *args, **options):
        key = str(uuid.uuid1())
        r_objs = Set('file:%s:upload' % key)
        r_objs.add('wait')
        while True:
            try:
                save_file(r_objs)
                time.sleep(1)
            except Exception, e:
                import traceback
                print traceback.print_exc()
                print "Save Local failed: %s" % e
                time.sleep(30)
